#include "defs.h"

#include <signal.h>
#include <errno.h>

extern int errno;
extern char ContentLength[];

char HTTPPROTO[] = "HTTP/1.0";

void initNet(){
	struct servent *sp;

	if((sp = getservbyname("http", "tcp")) != NULL) /* returns net order */
		HTTPPORT = sp->s_port;
	else    HTTPPORT = htons(80);

	if(basePort != 0)
		HTTPPORT = htons(basePort);
}

int TIMEOUT = 60 * 15;     /* 15 minutes */
Bool timed_out = FALSE;

static void onAlarm(int nsig){
	timed_out = TRUE;

	fprintf(stderr, "@ERROR timed out after %d seconds\n", TIMEOUT);
	fprintf(fplog,  "@ERROR timed out after %d seconds\n", TIMEOUT);
}

int callHost(List *list, URL *urlptr){
	struct sockaddr_in outAddr;
	in_addr_t addr;
	struct hostent *hp;
	int sock, tmpfd;
	int nread;
	int on = 1;
	size_t sent = 0;
	int code = 0;
	char message[4096];
	char *method = NULL;
	void (*savesig)();
	void (*swr)();

	char *hostname = urlptr->hostName;
	char *urlname  = urlptr->urlName;
	u_short port   = urlptr->port;

	if(proxyflag){
		hostname = proxy_host;
		port     = proxy_port;
		if(debugflag > 1) fprintf(stderr, "Proxy %s:%d\n", hostname, ntohs(port));
	}

	urlptr->trys++;         /* number of a trial */

	memset((char *) &outAddr, 0, sizeof(outAddr));

	outAddr.sin_family = AF_INET;
	outAddr.sin_port   = port;     /* net order */

	if((addr = inet_addr(hostname)) == -1){
		if((hp = MY_gethostbyname(hostname)) == NULL){
			fprintf(fplog, "Unknown host: %s\n", hostname);
			return UNKNOWN;

		} else saveAddrList(urlptr, hp);

		memcpy((char *) &outAddr.sin_addr, (hp->h_addr_list)[0], hp->h_length);
	} else {
		outAddr.sin_addr.s_addr = addr;
	}
	if(debugflag)
		fprintf(fplog, "\tUSEADDR: %s\n", inet_ntoa(outAddr.sin_addr));

	if((sock = socket(outAddr.sin_family, SOCK_STREAM, 0)) < 0){
		myperror("socket");
		return FAILED;
	}
	if(keepalive){
		on = 1; setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, (char *) &on, sizeof on);
	}
	if(connect(sock, (struct sockaddr *) &outAddr, sizeof(outAddr)) < 0){
		myperror("connect");
		close(sock);
		return (FAILED|RETRY);
	}

	if(debugflag > 1) fprintf(stderr, "Connected to %s\n", hostname);

	if((tmpfd = creat(tmpname, 0644)) < 0){
		myperror("creat");
		close(sock);
		return FAILED;
	}
	/* ----------------------------------------------------------- */
	code = CONNECTED;

	/* ----------- HTTP protocol --------------------------------- */
	if(urlptr->flags & USEPOST)
		method = "POST";
	else if (headOnly)
		method = "HEAD";
	else
		method = "GET";

	if(proxyflag){
		sprintf(message, "%s http://%s:%d%s %s\r\n", 
			method,
			urlptr->hostName,
			ntohs(urlptr->port),
			urlptr->urlName,
			HTTPPROTO);
		write(sock, message, strlen(message));
		if(debugflag > 2) fprintf(stderr, "\t%s", message);

		sprintf(message, "Host: %s:%d\r\n",
			urlptr->hostName,
			ntohs(urlptr->port)
		);
		write(sock, message, strlen(message));
		if(debugflag > 2) fprintf(stderr, "\t%s", message);

	} else {
		sprintf(message, "%s %s %s\r\n",
			method,
			urlname, HTTPPROTO);
		write(sock, message, strlen(message));
		if(debugflag > 2) fprintf(stderr, "\t%s", message);

		if(hostflag){
			sprintf(message, "Host: %s\r\n", hostname);
			write(sock, message, strlen(message));
			if(debugflag > 2) fprintf(stderr, "\t%s", message);
		}
	}
	if(urlptr->parentURL && urlptr->parentURL->fullName){
		sprintf(message, "Referer: %s\r\n", urlptr->parentURL->fullName);
		write(sock, message, strlen(message));
		if(debugflag > 2) fprintf(stderr, "\t%s", message);
	}

	sprintf(message, "User-Agent: Mozilla/4.75 [en] (X11; U; Linux 2.2.16.22 i686)\r\n");
	write(sock, message, strlen(message));
	if(debugflag > 2) fprintf(stderr, "\t%s", message);

#if 0
	sprintf(message, "Proxy-Connection: Keep-Alive\r\n");
	write(sock, message, strlen(message));
	if(debugflag > 2) fprintf(stderr, "\t%s", message);
#endif

	sprintf(message, "Pragma: no-cache\r\n");
	write(sock, message, strlen(message));
	if(debugflag > 2) fprintf(stderr, "\t%s", message);

	sprintf(message, "Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png, */*\r\n");
	write(sock, message, strlen(message));
	if(debugflag > 2) fprintf(stderr, "\t%s", message);

	if(use_gzip){
		sprintf(message, "Accept-Encoding: gzip\r\n");
		write(sock, message, strlen(message));
		if(debugflag > 2) fprintf(stderr, "\t%s", message);
	}

	if(authstring && *authstring){
		sprintf(message, "%s\r\n", authstring);
		write(sock, message, strlen(message));
		if(debugflag > 2) fprintf(stderr, "\t%s", message);
	}
	if(urlptr->flags & USEPOST){
		sprintf(message, "%s %ld\r\n", ContentLength, strlen(urlptr->post_data));
		write(sock, message, strlen(message));
		if(debugflag > 2) fprintf(stderr, "\t%s", message);
	}

	sprintf(message, "\r\n");
	write(sock, message, strlen(message));
	if(debugflag > 2) fprintf(stderr, "\t%s", message);

	if(urlptr->flags & USEPOST){
		sprintf(message, "%s\r\n", urlptr->post_data);
		write(sock, message, strlen(message));
		if(debugflag > 2) fprintf(stderr, "\t%s", message);
	}

	if(debugflag > 1) fprintf(stderr, "Sent request for %s\n", urlname);

	if(debugflag){
		int toretry;
		int rest = countRemaining(list, &toretry);

		fprintf(stderr, "[%lu.%ld:%d/%ld] %s %s %s:%u%s\n[%d URLs left, %d to retry]\n",
			urlptr->serial,
			urlptr->level,
			urlptr->hops,
			urlptr->trys,
			currentDate(),

			urlptr->trys == 1 ? "Contacting" : "Retrying",

			hostname,
			ntohs(port),
			urlname,
			rest,
			toretry
		);
		if(proxyflag)
		fprintf(stderr, "[http://%s:%d%s]\n",
			urlptr->hostName,
			ntohs(urlptr->port),
			urlptr->urlName);
	}

	for(;;){

		errno = 0;
		timed_out = FALSE;
		savesig = sigset(SIGALRM, onAlarm);
		alarm(TIMEOUT);

		nread = read(sock, message, sizeof(message));

		alarm(0);

		if(skip_this){
			if(skip_this == 2)
				code |= (FAILED|RETRY);
			else	code |= (FAILED|IGNORED);
			myperror("file download abandoned");
			errno = 0;
			break;
		}
		if(nread <= 0 && timed_out == TRUE){
			errno = ETIMEDOUT;
			nread = (-1);
			break;
		}
		if(nread <= 0 && errno == EINTR && restart_intr){
			myperror("net read interrupted");
			continue;
		}
		if(nread <= 0)
			break;

		swr = sigset(SIGINT, SIG_IGN);
		if(write(tmpfd, message, nread) != nread){
			sigset(SIGINT, swr);
			fprintf(stderr, "@@@ FATAL ERROR writing tmp file: %s\n", strerror(errno));
			fprintf(fplog,  "@@@ FATAL ERROR writing tmp file: %s\n", strerror(errno));
			myperror("tmp write");
			code |= (FAILED|RETRY);
			break;
		}
		sigset(SIGINT, swr);
		sent += nread;
		if(debugflag)
		       fprintf(stderr, "Sent: %lu\r", sent);
	}
	sigset(SIGALRM, savesig);

	if(nread < 0 && errno != 0){
		myperror("net read");
		code |= (FAILED|RETRY);
	}
	if(debugflag)
	       fprintf(stderr, "Sent: %lu\n", sent);

	close(tmpfd);
	close(sock);

	if(relaxtime)
		sleep(relaxtime);

	if(skip_this){
		fprintf(stderr, "@@@ DOCUMENT SKIPPED\n");
		fprintf(fplog,  "@@@ DOCUMENT SKIPPED\n");
	}
	else
		processDocument(list, urlptr, tmpname);
	unlink(tmpname);
	skip_this = 0;

	return code;
}
